﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class MapProviderSideApptRequestStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.AppointmentType == AppointmentType.STORE_FORWARD)
                return;
            state.ProEcRequest = new MakeAppointmentMapper().MapMakeAppointmentRequest(state, Side.Provider);
            var siteCode = state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_loginSiteCode;

            if (string.IsNullOrEmpty(state.ProUserDuz))
                state.ProLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteCode, state.OrganizationServiceProxy, state.SAMLToken);
            else
                state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = state.ProUserDuz;
        }
    }
}
